/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIDlparResourceSync;
import com.ibm.hsc.cim.provider.pi.PIHscMProviderBase;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspFileInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspFileOpenResponse;
import com.ibm.hsc.lock.Lockable;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.frame.OmFrameMgr;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;

public class PIDumpMethProv
extends PIHscMProviderBase {
    public static final int SUCCESSFUL = 0;
    public static final int FAIL = -1;
    private String _dumpType = "";
    private static final String MOUNT_PARTITION = "/dump";
    private static final String PARTIAL = ".PARTIAL";
    private static final String INITIALIZE_DUMP = "InitializeDump";
    private static final String INITIALIZE_SP_DUMP = "InitializeSPDump";
    private static final String READ_DUMP = "ReadDump";
    private static final String QUERY_DUMP = "QueryDump";
    private static final String PLATFORM_DUMP_DIR = "/";
    private static final String FSP_DUMP_DIR = "/";
    private static final String PLATFORM_EVENT_LOG_DUMP_DIR = "/";
    private static final String SMA_DUMP_DIR = "/";
    private static final String POWER_SUB_SYSTEM_DUMP_DIR = "/";
    private static final String TMP_FILE = "/tmp";
    private static final String DUMP_SAVED_LOCATION = "/saved";
    private static final String DUMP_FILE_SEPERATOR = "/";
    private static final String DUMP_PROPERTY_FILE = "/opt/hsc/data/HMCDump.properties";
    private static final String MAX_NO_OF_DUMP = "MAX_NO_OF_DUMP";
    private static final String DUMP_MOVE_COMMAND = "/bin/mv ";
    private static final String MOUNT_COMMAND = "/bin/mount ";
    private static final String DUMP_COPY_CMD = "/bin/cp";
    private static final String FSPDUMP = "FSPDUMP";
    private static final String SYSDUMP = "SYSDUMP";
    private static final String LOGDUMP = "LOGDUMP";
    private static final String SMADUMP = "SMADUMP";
    private static final String PWRDUMP = "PWRDUMP";
    private final String MOF_NO_OF_DUMPS = "noOfDumps";
    private final String MOF_DUMP_NO_TYPES = "noTypes";
    private final String MOF_DUMP_FILE_NAME = "dumpFileName";
    private final String DUMP_ENTRY_HEADER = "FILE";
    private CIMObjectPath cimObjPath = null;
    private String cecName = "";
    private OmCecMgr cecMgr = null;
    private static String MOF_NAME = "Name";
    private final String MOF_LPAR_SLOT_ID = "LPARSlotID";
    private final String MOF_MEM_REGION = "memRegion";

    protected Lockable getLockable(String string, CIMObjectPath cIMObjectPath, Vector vector) throws PIHscServerException, CIMException {
        return null;
    }

    private String _getObjectName(CIMObjectPath cIMObjectPath) {
        CIMProperty cIMProperty = null;
        String string = null;
        Vector vector = cIMObjectPath.getKeys();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            cIMProperty = (CIMProperty)vector.elementAt(i);
            if (!cIMProperty.getName().equals("Name")) continue;
            string = (String)cIMProperty.getValue().getValue();
            break;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue invokeMethodImpl(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws PIHscServerException {
        CIMValue cIMValue;
        block23: {
            if (1 <= Trace.LEVEL) {
                Trace.trace("aphihscF", "-> PIDumpMethProv.invokeMethodImpl");
            }
            this.cimObjPath = cIMObjectPath;
            cIMValue = new CIMValue((Object)new UnsignedInt8(1));
            try {
                try {
                    block22: {
                        String string2 = null;
                        CIMProperty cIMProperty = null;
                        if (READ_DUMP.equals(string)) {
                            cIMProperty = (CIMProperty)vector.elementAt(1);
                            string2 = (String)cIMProperty.getValue().getValue();
                        } else {
                            cIMProperty = (CIMProperty)vector.elementAt(0);
                            string2 = (String)cIMProperty.getValue().getValue();
                        }
                        System.out.println("side=" + string2);
                        CIMInstance cIMInstance = null;
                        if ("PRIMARY".equals(string2)) {
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, new CIMClass("IBMHSC_ComputerSystem"), false);
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("aphihscF", "cecInst = " + cIMInstance);
                            }
                            if (cIMInstance == null) {
                                String[] stringArray = new String[]{cIMObjectPath.toString()};
                                throw new PIHscServerException("1586", stringArray, null);
                            }
                        } else if ("SIDE_A".equals(string2) || "SIDE_B".equals(string2)) {
                            cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.m_CimomHandle, cIMObjectPath, new CIMClass("IBMHSC_Frame"), false);
                            if (2 <= Trace.LEVEL) {
                                Trace.trace("aphihscF", "frameInst = " + cIMInstance);
                            }
                        }
                        if (cIMInstance != null) {
                            this.cecName = (String)cIMInstance.getProperty("Name").getValue().getValue();
                        }
                        if (2 <= Trace.LEVEL) {
                            Trace.trace("aphihscF", "Name = " + this.cecName);
                        }
                        OmSysMgr omSysMgr = OmSysMgr.getSysMgr(this.cecName);
                        try {
                            if (INITIALIZE_DUMP.equals(string)) {
                                this.debug("calling InitializeDump for side " + string2);
                                cIMValue = this.InitializeDump(omSysMgr, string2);
                                break block22;
                            }
                            if (INITIALIZE_SP_DUMP.equals(string)) {
                                this.debug("calling InitializeSPDump for side " + string2);
                                cIMValue = this.InitializeSPDump(omSysMgr, string2);
                                break block22;
                            }
                            if (READ_DUMP.equals(string)) {
                                CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(0);
                                String string3 = (String)cIMProperty2.getValue().getValue();
                                this.debug("calling ReadDump with type as " + string3 + " and side as " + string2);
                                cIMValue = this.ReadDump(omSysMgr, string3, vector2, string2);
                            } else {
                                if (!QUERY_DUMP.equals(string)) {
                                    String[] stringArray = new String[]{string};
                                    throw new PIHscServerException("1581", stringArray, null);
                                }
                                this.debug("calling QueryDump for side " + string2);
                                cIMValue = this.QueryDump(omSysMgr, vector2, string2);
                            }
                        }
                        catch (Exception exception) {
                            HSCLogUtils.serverLog(exception, HSCLogUtils._PartActClassLogInfo);
                        }
                    }
                    Object var13_16 = null;
                    if (1 > Trace.LEVEL) break block23;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    throw new PIHscServerException("1773", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (1 > Trace.LEVEL) return cIMValue;
                Trace.trace("aphihscT", "<- invokeMethod");
                return cIMValue;
            }
            Trace.trace("aphihscT", "<- invokeMethod");
        }
        return cIMValue;
    }

    private int getNumberOfDumps(String string) throws PIHscServerException {
        this.debug("in getNumberOfDumps() for " + string);
        File file = new File(string);
        if (file.exists()) {
            int n = file.listFiles().length;
            this.debug("no of files : " + n);
            return n;
        }
        return -1;
    }

    private boolean isDumpPartitionExists() throws PIHscServerException {
        File file = new File(MOUNT_PARTITION);
        return file.exists();
    }

    private boolean isDumpDirectoryExists(String string) throws PIHscServerException {
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    private boolean createDumpDirectory(String string) throws PIHscServerException {
        File file = new File(string);
        try {
            return file.mkdir();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean mountDumpPartition() throws PIHscServerException {
        this.debug("Mounting dump partition");
        boolean bl = false;
        try {
            String string = "/bin/mount /dump";
            this.debug("dump cmd is : " + string);
            Process process = Runtime.getRuntime().exec(string);
            bl = this.isDumpPartitionExists();
            this.debug("isDumpPartitionExists() -> " + bl);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("0608", throwable);
        }
        finally {
            return bl;
        }
    }

    private boolean moveDumpsToNewLocation(String string) throws PIHscServerException {
        boolean bl = false;
        try {
            int n = this.getNumberOfDumps(MOUNT_PARTITION + string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DUMP_MOVE_COMMAND);
            stringBuffer.append("  ");
            stringBuffer.append(MOUNT_PARTITION);
            stringBuffer.append(string);
            stringBuffer.append("  ");
            stringBuffer.append(MOUNT_PARTITION);
            stringBuffer.append(DUMP_SAVED_LOCATION);
            stringBuffer.append(string);
            String string2 = new String(stringBuffer);
            if (2 <= Trace.LEVEL) {
                Trace.trace("aphihscF", "moveDumpsToNewLocation = " + string2);
            }
            Process process = Runtime.getRuntime().exec(string2);
            int n2 = this.getNumberOfDumps("/dump/saved" + string);
            int n3 = this.getNumberOfDumps(MOUNT_PARTITION + string);
            if (n3 != 0) {
                if (n != n2) {
                    bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("0609", throwable);
        }
        finally {
            return bl;
        }
    }

    private int getMaximumAllowableDumps() throws PIHscServerException {
        int n = 0;
        n = 4;
        return n;
    }

    private File readDumpToTempFile(String string, byte[] byArray) throws PIHscServerException {
        File file = null;
        try {
            String string2;
            String string3 = "";
            String string4 = "";
            if ("sp".equals(string.trim())) {
                string3 = "/dump/";
                string4 = "/";
            } else if ("sys".equals(string.trim())) {
                string3 = "/dump/";
                string4 = "/";
            } else if ("eventlog".equals(string.trim())) {
                string3 = "/dump/";
                string4 = "/";
            } else if ("sma".equals(string.trim())) {
                string3 = "/dump/";
                string4 = "/";
            } else if ("pss".equals(string.trim())) {
                string3 = "/dump/";
                string4 = "/";
            }
            if (this.getMaximumAllowableDumps() == this.getNumberOfDumps(string3)) {
                this.moveDumpsToNewLocation(string4);
            }
            if ((file = new File(string2 = string3 + TMP_FILE)).exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("0611", throwable);
        }
        finally {
            return file;
        }
    }

    private boolean processDumpFileHeader(File file, Vector vector) throws PIHscServerException {
        this.debug("Entering processDumpFileHeader()");
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[8];
            byte[] byArray2 = new byte[39];
            bufferedInputStream.read(byArray, 0, 8);
            String string = "";
            String string2 = "";
            string = new String(byArray);
            if ("FILE".equals(string.trim())) {
                bufferedInputStream.skip(16L);
            }
            bufferedInputStream.read(byArray2, 0, 39);
            string2 = new String(byArray2);
            this.debug("file name is : " + string2);
            bufferedInputStream.close();
            fileInputStream.close();
            String string3 = string2.substring(0, 7);
            String string4 = "";
            if (SYSDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (FSPDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (LOGDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (SMADUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (PWRDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            }
            this.debug("Dump file directory : " + string4);
            this.debug("check for DumpPartition");
            if (!this.isDumpPartitionExists()) {
                this.debug("calling mountDumpPartition");
                this.mountDumpPartition();
            }
            this.debug("check for dump directory");
            if (!this.isDumpDirectoryExists(string4 + "/")) {
                this.debug("creating a dump directory");
                this.createDumpDirectory(string4 + "/");
            }
            this.debug("converting extracted dump file to respective directory");
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            vector.addElement(new CIMProperty("dumpFileName", new CIMValue((Object)throwable.toString(), new CIMDataType(9))));
            bl = false;
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("0612", throwable);
        }
        finally {
            return bl;
        }
    }

    private boolean processDumpHeader(byte[] byArray, File file, Vector vector) throws PIHscServerException {
        boolean bl = false;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[39];
            String string = "";
            String string2 = "";
            dataInputStream.read(byArray2, 0, 8);
            string = new String(byArray2);
            if ("FILE".equals(string.trim())) {
                dataInputStream.skipBytes(16);
            }
            dataInputStream.read(byArray3, 0, 39);
            string2 = new String(byArray3);
            byteArrayInputStream.close();
            dataInputStream.close();
            String string3 = string2.substring(0, 7);
            String string4 = "";
            if (SYSDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (FSPDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (LOGDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (SMADUMP.equals(string3.trim())) {
                string4 = "/dump/";
            } else if (PWRDUMP.equals(string3.trim())) {
                string4 = "/dump/";
            }
            File file2 = new File(string4 + "/" + string2.trim());
            if (file2.exists()) {
                file2.delete();
            }
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            vector.addElement(new CIMProperty("dumpFileName", new CIMValue((Object)file2.toString(), new CIMDataType(9))));
            bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            vector.addElement(new CIMProperty("dumpFileName", new CIMValue((Object)throwable.toString(), new CIMDataType(9))));
            bl = false;
            HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
            throw new PIHscServerException("0612", throwable);
        }
        finally {
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue InitializeSPDump(OmSysMgr omSysMgr, String string) throws PIHscServerException {
        this.debug("in InitializeSPDump()");
        CIMValue cIMValue = null;
        try {
            try {
                omSysMgr.getCmdHelper().initializeSPDump(string);
                cIMValue = new CIMValue((Object)new UnsignedInt8(0));
            }
            catch (Throwable throwable) {
                this.debug("Dump Service Processor - Initialize FSP Dump");
                throwable.printStackTrace();
                System.out.println(" error = " + throwable.toString());
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                throw new PIHscServerException("0605", throwable);
            }
            Object var6_4 = null;
            if (1 > Trace.LEVEL) return cIMValue;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (1 > Trace.LEVEL) return cIMValue;
            Trace.trace("aphihscT", "<- InitializeFSPDump");
            return cIMValue;
        }
        Trace.trace("aphihscT", "<- InitializeFSPDump");
        return cIMValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue InitializeDump(OmSysMgr omSysMgr, String string) throws PIHscServerException {
        CIMValue cIMValue = null;
        try {
            try {
                omSysMgr.getCmdHelper().initializeDump(string);
                cIMValue = new CIMValue((Object)new UnsignedInt8(0));
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                throw new PIHscServerException("0605", throwable);
            }
            Object var6_4 = null;
            if (1 > Trace.LEVEL) return cIMValue;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (1 > Trace.LEVEL) return cIMValue;
            Trace.trace("aphihscT", "<- InitializeDump");
            return cIMValue;
        }
        Trace.trace("aphihscT", "<- InitializeDump");
        return cIMValue;
    }

    private long getFileSize(OmSysMgr omSysMgr, int n, long l) throws PIHscServerException {
        this.debug("in getFileSize()");
        long l2 = omSysMgr.getCmdHelper().getFileSize(n, l);
        return l2;
    }

    private FspFileOpenResponse openFile(OmSysMgr omSysMgr, int n, long l, String string) throws PIHscServerException {
        this.debug("in openFile()");
        FspFileOpenResponse fspFileOpenResponse = null;
        if (omSysMgr instanceof OmCecMgr) {
            fspFileOpenResponse = ((OmCecMgr)omSysMgr).getCmdHelper().openFile(n, l, (short)1, (short)0, 0L, 0L);
        } else if (omSysMgr instanceof OmFrameMgr) {
            fspFileOpenResponse = ((OmFrameMgr)omSysMgr).getCmdHelper().openBpcFile(n, l, (short)1, (short)0, 0L, 0L, string);
        }
        return fspFileOpenResponse;
    }

    private byte[] readFile(OmSysMgr omSysMgr, int n, long l, long l2) throws PIHscServerException {
        this.debug("in readFile()");
        byte[] byArray = null;
        if (omSysMgr instanceof OmCecMgr) {
            byArray = ((OmCecMgr)omSysMgr).getCmdHelper().readFile(n, l, 0L, l2);
        } else if (omSysMgr instanceof OmFrameMgr) {
            byArray = ((OmFrameMgr)omSysMgr).getCmdHelper().readFile(n, l, 0L, l2);
        }
        return byArray;
    }

    private void closeFile(OmSysMgr omSysMgr, int n, long l, String string) throws PIHscServerException {
        this.debug("in closeFile()");
        if (omSysMgr instanceof OmCecMgr) {
            ((OmCecMgr)omSysMgr).getCmdHelper().closeFile(n, l, 128L);
        } else if (omSysMgr instanceof OmFrameMgr) {
            ((OmFrameMgr)omSysMgr).getCmdHelper().closeBpcFile(n, l, 128L, string);
        }
    }

    private void acknowledgeDump(OmSysMgr omSysMgr, int n, long l, String string) throws PIHscServerException {
        this.debug("in acknowledgeDump()");
        if (omSysMgr instanceof OmCecMgr) {
            ((OmCecMgr)omSysMgr).getCmdHelper().acknowledgeDump(n, l, string);
        } else if (omSysMgr instanceof OmFrameMgr) {
            ((OmFrameMgr)omSysMgr).getCmdHelper().acknowledgeDump(n, l, string);
        }
    }

    private int getFileID(String string) {
        int n = 0;
        if ("sp".equals(string.trim())) {
            n = 1;
        } else if ("sys".equals(string.trim())) {
            n = 8;
        } else if ("sma".equals(string.trim())) {
            n = 17;
        } else if ("eventlog".equals(string.trim())) {
            n = 3;
        } else if ("pss".equals(string.trim())) {
            n = 21;
        } else if ("any".equals(string.trim())) {
            n = 19;
        }
        return n;
    }

    public CIMValue QueryDump(OmSysMgr omSysMgr, Vector vector, String string) throws PIHscServerException {
        this.debug("in QueryDump()");
        CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(0));
        long l = 0L;
        CIMValue cIMValue2 = null;
        try {
            String[] stringArray;
            int n;
            Vector vector2 = null;
            if ("PRIMARY".equals(string)) {
                vector2 = ((OmCecMgr)omSysMgr).getCmdHelper().getFileInstanceList(19, l);
            } else if ("SIDE_A".equals(string) || "SIDE_B".equals(string)) {
                vector2 = ((OmFrameMgr)omSysMgr).getCmdHelper().getBpcFileInstanceList(19, l, string);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            this.debug("getFileInstanceList() returns : " + vector2.size());
            for (n = 0; n < vector2.size(); ++n) {
                stringArray = (String[])vector2.get(n);
                if (stringArray != null && stringArray.getFileId() == 8) {
                    ++n2;
                }
                if (stringArray != null && stringArray.getFileId() == 1) {
                    ++n3;
                }
                if (stringArray == null || stringArray.getFileId() != 21) continue;
                ++n4;
            }
            this.debug("Available dumps : platform = " + n2 + ", fsp = " + n3 + ", pss=" + n4);
            n = vector2.size();
            if (n > 0) {
                cIMValue = new CIMValue((Object)new UnsignedInt8((short)n));
            }
            cIMValue2 = new CIMValue((Object)new UnsignedInt8((short)n), new CIMDataType(1));
            vector.addElement(new CIMProperty("noOfDumps", cIMValue2));
            stringArray = new String[]{"" + n2, "" + n3, "" + n4};
            cIMValue2 = new CIMValue((Object)stringArray, new CIMDataType(29));
            vector.addElement(new CIMProperty("noTypes", cIMValue2));
        }
        catch (Throwable throwable) {
            cIMValue2 = new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1));
            vector.addElement(new CIMProperty("noOfDumps", cIMValue2));
            String[] stringArray = new String[]{"0", "0", "0"};
            cIMValue2 = new CIMValue((Object)stringArray, new CIMDataType(29));
            vector.addElement(new CIMProperty("noTypes", cIMValue2));
            throw new PIHscServerException("0613", throwable);
        }
        finally {
            return cIMValue;
        }
    }

    private void freedUpDumpDir(String string, String string2) throws PIHscServerException {
        this.debug("in freedUpDumpDir()");
        String string3 = "/dump/";
        String string4 = "/opt/hsc/bin/clearDumpDir ";
        int n = 0;
        if ("sp".equals(string.trim())) {
            string3 = string3 + "FSPDUMP.*";
            string4 = string4 + "  FSPDUMP." + string2;
            this.debug("cmd is " + string4);
        } else if ("sys".equals(string.trim())) {
            string3 = string3 + "SYSDUMP.*";
            string4 = string4 + "  SYSDUMP." + string2;
            this.debug("cmd is " + string4);
        }
        try {
            n = this.getMaximumAllowableDumps();
            this.debug("allowableDump = " + n);
            string4 = string4 + " " + n;
            try {
                this.debug("clearDumpDir  cmd is : " + string4);
                Process process = Runtime.getRuntime().exec(string4);
                process.waitFor();
            }
            catch (Throwable throwable) {
                this.debug("error while running clearDumpDir cmd : " + throwable.toString());
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                throw new PIHscServerException("0608", throwable);
            }
        }
        catch (PIHscServerException pIHscServerException) {
            this.debug("Error in freedUpDumpDir() : " + pIHscServerException.toString());
            throw pIHscServerException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMValue ReadDump(OmSysMgr omSysMgr, String string, Vector vector, String string2) throws PIHscServerException {
        this.debug("Dump Extraction Starts.....");
        CIMValue cIMValue = new CIMValue((Object)new UnsignedInt8(0));
        try {
            block25: {
                try {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace("aphihscT", "-> _readDump");
                    }
                    int n = this.getFileID(string.trim());
                    long l = 0L;
                    Vector vector2 = new Vector();
                    if (omSysMgr instanceof OmCecMgr) {
                        vector2 = ((OmCecMgr)omSysMgr).getCmdHelper().getFileInstanceList(n, l);
                    } else if (omSysMgr instanceof OmFrameMgr) {
                        vector2 = ((OmFrameMgr)omSysMgr).getCmdHelper().getBpcFileInstanceList(n, l, string2);
                    }
                    int n2 = vector2.size();
                    this.debug("Available subId for " + string + " is : " + n2);
                    if (n2 > 0) {
                        for (int i = 0; i < n2; ++i) {
                            Object v0;
                            FspFileInfo fspFileInfo = (FspFileInfo)vector2.elementAt(i);
                            if (fspFileInfo.getFileSize() <= 0L) continue;
                            boolean bl = false;
                            try {
                                try {
                                    this.debug("Opening dump file");
                                    FspFileOpenResponse fspFileOpenResponse = this.openFile(omSysMgr, fspFileInfo.getFileId(), fspFileInfo.getSubId(), string2);
                                    bl = true;
                                    this.debug("Reading dump file");
                                    File file = omSysMgr.getCmdHelper().readDumpFile(fspFileInfo.getFileId(), fspFileInfo.getSubId(), 0L, fspFileOpenResponse.getFileSize(), string2);
                                    this.debug("Tmp file is stored on " + file.getName());
                                    this.debug("Tmp file size is : " + file.length());
                                    vector.addElement(new CIMProperty("dumpFileName", new CIMValue((Object)file.toString(), new CIMDataType(9))));
                                    boolean bl2 = true;
                                    if (omSysMgr instanceof OmCecMgr) {
                                        bl2 = ((OmCecMgr)omSysMgr).getCmdHelper().canInvalidateDump();
                                    } else if (omSysMgr instanceof OmFrameMgr) {
                                        bl2 = ((OmFrameMgr)omSysMgr).getCmdHelper().canInvalidateDump();
                                    }
                                    this.debug("sys.getCmdHelper().canInvalidateDump():" + bl2);
                                    if (bl2) {
                                        File file2;
                                        this.debug("validating a dump after a read");
                                        this.acknowledgeDump(omSysMgr, fspFileInfo.getFileId(), fspFileInfo.getSubId(), string2);
                                        this.debug("_hmcDump.getName().trim().length()=" + file.getName().trim().length());
                                        if (file != null && file.getName().trim().length() == 39 && (file2 = new File("/dump/" + file.getName().trim() + PARTIAL)) != null && file2.exists()) {
                                            this.debug("partial file " + file2.getName() + " exists");
                                            long l2 = file.length();
                                            long l3 = file2.length();
                                            this.debug("actualFileLength=" + l2 + ", partialFileLength=" + l3);
                                            if (l2 > l3) {
                                                this.debug("about to delete partial file");
                                                file2.delete();
                                            } else if (l2 < l3) {
                                                this.debug("about to delete actual file");
                                                file.delete();
                                            }
                                        }
                                    }
                                    v0 = null;
                                }
                                catch (Throwable throwable) {
                                    this.debug("error in read dump filr or acknowledge ");
                                    throwable.printStackTrace();
                                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                                    throw new PIHscServerException("0604", throwable);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var23_22;
                                v0 = var23_22 = null;
                            }
                            if (bl) {
                                this.debug("Closing dump file");
                                this.closeFile(omSysMgr, fspFileInfo.getFileId(), fspFileInfo.getSubId(), string2);
                            }
                            String string3 = this.cecMgr.getCecName();
                            string3 = string3.substring(string3.indexOf("*") + 1, string3.length());
                            this.debug("serial number is " + string3.trim());
                            this.freedUpDumpDir(string.trim(), string3.trim());
                        }
                        this.debug("Calling Recovery routine");
                        PIDlparResourceSync.memoryRecoveryForDump(this.cecMgr, this.cimObjPath, this.m_CimomHandle);
                        break block25;
                    }
                    cIMValue = new CIMValue((Object)new UnsignedInt8(1));
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._PartActClassLogInfo);
                    throw new PIHscServerException("0604", throwable);
                }
            }
            Object var26_24 = null;
            if (1 <= Trace.LEVEL) {
                Trace.trace("aphihscT", "<- ReadDump");
            }
            return cIMValue;
        }
        catch (Throwable throwable) {
            Object var26_25 = null;
            if (1 > Trace.LEVEL) return cIMValue;
            Trace.trace("aphihscT", "<- ReadDump");
            return cIMValue;
        }
    }

    private void debug(String string) {
        System.out.println("DUMP." + string);
    }
}

